<?php

App::uses('AppHelper', 'View/Helper');

/**
 * This class was written based on the worpress shortcode http://core.svn.wordpress.org/trunk/wp-includes/shortcodes.php
 * http://bakery.cakephp.org/articles/eugenioclrc/2010/08/29/complete-bbcode-helper-with-custom-tags
 */
class ShortcodeHelper extends AppHelper
{
    protected $shortcode_tags = array();
    
    public function __construct(View $View, $settings = array())
    {
        parent::__construct($View, $settings);
    }

    public function add_shortcode($tag, $func = null)
    {
        if (is_array($tag)) {
            foreach ($tag as $code) {
                $this->add_shortcode($code[0], $code[1]);
            }
        } elseif (is_callable($func)) {
            $this->shortcode_tags[$tag] = $func;
        }
        return $this;
    }

    public function remove_shortcode($tag)
    {
        unset($this->shortcode_tags[$tag]);
        return $this;
    }

    public function remove_all_shortcodes()
    {
        $this->shortcode_tags = array();
        return $this;
    }

    public function doShortcode($content)
    {
        $content = $this->_beforeShortcode($content);
        $content = $this->do_shortcode($content);
        $content = $this->_afterShortcode($content);

        return $content;
    }

    protected function _beforeShortcode($content)
    {
        return $content;
    }

    protected function _afterShortcode($content)
    {
        return $content;
    }

    protected function do_shortcode($content)
    {
        if (empty($this->shortcode_tags) || !is_array($this->shortcode_tags)) {
            return $content;
        }

        $pattern = $this->get_shortcode_regex();
        return preg_replace_callback('/' . $pattern . '/s', array(&$this, 'do_shortcode_tag'), $content);
    }

    public function get_shortcode_regex()
    {
        $tagnames = array_keys($this->shortcode_tags);
        $tagregexp = join('|', array_map('preg_quote', $tagnames));

        // WARNING! Do not change this regex without changing do_shortcode_tag() and strip_shortcodes()
        return '(.?)\[(' . $tagregexp . ')\b(.*?)(?:(\/))?\](?:(.+?)\[\/\2\])?(.?)';
    }

    public function do_shortcode_tag($m)
    {
        // allow [[foo]] syntax for escaping a tag
        if ($m[1] == '[' && $m[6] == ']') {
            return substr($m[0], 1, -1);
        }

        $tag = $m[2];
        $attr = $this->shortcode_parse_atts($m[3]);

        if (isset($m[5])) {
            // enclosing tag - extra parameter
            return $m[1] . call_user_func($this->shortcode_tags[$tag], $attr, $m[5], $tag) . $m[6];
        } else {
            // self-closing tag
            return $m[1] . call_user_func($this->$shortcode_tags[$tag], $attr, null, $tag) . $m[6];
        }
    }

    public function shortcode_parse_atts($text)
    {
        $atts = array();
        $pattern = '/(\w+)\s*=\s*"([^"]*)"(?:\s|$)|(\w+)\s*=\s*\'([^\']*)\'(?:\s|$)|(\w+)\s*=\s*([^\s\'"]+)(?:\s|$)|"([^"]*)"(?:\s|$)|(\S+)(?:\s|$)/';
        $text = preg_replace("/[\x{00a0}\x{200b}]+/u", " ", $text);
        if (preg_match_all($pattern, $text, $match, PREG_SET_ORDER)) {
            foreach ($match as $m) {
                if (!empty($m[1])) {
                    $atts[strtolower($m[1])] = stripcslashes($m[2]);
                } elseif (!empty($m[3])) {
                    $atts[strtolower($m[3])] = stripcslashes($m[4]);
                } elseif (!empty($m[5])) {
                    $atts[strtolower($m[5])] = stripcslashes($m[6]);
                } elseif (isset($m[7]) and strlen($m[7])) {
                    $atts[] = stripcslashes($m[7]);
                } elseif (isset($m[8])) {
                    $atts[] = stripcslashes($m[8]);
                }
            }
        } else {
            $atts = ltrim($text);
        }
        return $atts;
    }

    public function shortcode_atts($pairs, $atts)
    {
        $atts = (array) $atts;
        $out = array();
        foreach ($pairs as $name => $default) {
            if (array_key_exists($name, $atts)) {
                $out[$name] = $atts[$name];
            } else {
                $out[$name] = $default;
            }
        }
        return $out;
    }

    public function strip_shortcodes($content)
    {
        if (empty($this->shortcode_tags) || !is_array($this->shortcode_tags)) {
            return $content;
        }

        $pattern = $this->get_shortcode_regex();

        return preg_replace('/' . $this->pattern . '/s', '$1$6', $content);
    }
}
